<?php declare(strict_types = 1);

namespace Core\Model\Event;

use Core\Model\Templating\Template;
use Core\Model\UI\AbstractPresenter;
use Core\Model\UI\Form\BaseForm;
use Nette\Application\UI\Control;
use Nette\Utils\ArrayHash;
use Symfony\Contracts\EventDispatcher\Event;

class FormSuccessEvent extends Event
{
	public ArrayHash          $values;
	public ?BaseForm          $form      = null;
	public ?Template          $template  = null;
	public ?AbstractPresenter $presenter = null;
	public ?Control           $control   = null;
	public array              $custom    = [];

	public function __construct(?BaseForm $form, ArrayHash $values, ?Template $template, ?AbstractPresenter $presenter)
	{
		$this->form      = $form;
		$this->values    = $values;
		$this->template  = $template;
		$this->presenter = $presenter;
	}
}
