<?php declare(strict_types = 1);

namespace Core\Model\Event;

use Nette\ComponentModel\IContainer;
use Nette\Utils\Html;
use Symfony\Contracts\EventDispatcher\Event;

class PartRenderEvent extends Event
{
	protected string     $key;
	protected IContainer $control;
	protected array      $data = [];

	public function __construct(string $key, IContainer $control)
	{
		$this->key     = $key;
		$this->control = $control;
	}

	public function getKey(): string { return $this->key; }

	public function getControl(): IContainer { return $this->control; }

	public function getData(): array { return $this->data; }

	/**
	 * @param string|array|Html $value
	 */
	protected function addData(string $type, $value): void
	{
		$this->data[] = [
			'type' => $type,
			'data' => $value,
		];
	}

	public function addRenderHtml(Html $html): void { $this->addData('html', $html); }

	public function addRenderFile(string $file): void { $this->addData('file', $file); }

	public function addRenderTemplate(string $file, array $params, array $data = []): void
	{
		$this->addData('template', [
			'file'   => $file,
			'params' => $params,
			'data'   => $data,
		]);
	}
}
