<?php declare(strict_types = 1);

namespace Core\Model\Helpers;

use Contributte\Translation\Translator;
use Core\Model\Settings;
use Doctrine\ORM\EntityRepository;
use Core\Model\Entities\EntityManagerDecorator;

abstract class BaseFrontEntityService extends BaseService
{
	/** @var EntityManagerDecorator @inject */
	public $em;

	/** @var Translator @inject */
	public $translator;

	/** @var Settings @inject */
	public $settings;

	/** @var EntityRepository */
	protected $er;

	/** @var string */
	protected $entityClass;

	/** @return EntityRepository */
	public function getEr()
	{
		if ($this->er === null) {
			$this->er = $this->em->getRepository($this->entityClass);
		}

		return $this->er;
	}
}
