<?php declare(strict_types = 1);

namespace Core\Model\Http;

use Nette\InvalidArgumentException;

class PdfResponse
{
	public static function sendResponse(string $filename, string $data, string $destination): void
	{
		switch ($destination) {

			case 'I':
				if (PHP_SAPI !== 'cli') {
					header('Content-Type: application/pdf');

					if (!isset($_SERVER['HTTP_ACCEPT_ENCODING']) || empty($_SERVER['HTTP_ACCEPT_ENCODING'])) {
						// don't use length if server using compression
						header('Content-Length: ' . strlen($data));
					}

					header('Content-disposition: inline; filename="' . $filename . '"');
					header('Cache-Control: public, must-revalidate, max-age=0');
					header('Pragma: public');
					header('Expires: Sat, 26 Jul 1997 05:00:00 GMT');
					header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
				}

				echo $data;

				break;

			case 'D':

				if (headers_sent()) {
					throw new \Exception('Data has already been sent to output, unable to output PDF file');
				}

				header('Content-Description: File Transfer');
				header('Content-Transfer-Encoding: binary');
				header('Cache-Control: public, must-revalidate, max-age=0');
				header('Pragma: public');
				header('Expires: Sat, 26 Jul 1997 05:00:00 GMT');
				header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
				header('Content-Type: application/pdf');

				if (!isset($_SERVER['HTTP_ACCEPT_ENCODING']) || empty($_SERVER['HTTP_ACCEPT_ENCODING'])) {
					// don't use length if server using compression
					header('Content-Length: ' . strlen($data));
				}

				header('Content-Disposition: attachment; filename="' . $filename . '"');

				echo $data;

				break;

			default:
				throw new InvalidArgumentException(sprintf('Incorrect output destination %s', $destination));
		}
	}
}