<?php declare(strict_types = 1);

namespace Core\Model\Navigation;

use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Doctrine\ORM\Query\Expr\Join;
use Navigations\AdminModule\Model\Navigations;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;

class Alias extends BaseNavigation implements INavigationItem
{
	protected $title = 'alias';

	const TYPE = 'navigation.alias';

	protected Navigations $navigationsService;

	public function __construct(
		Navigations $navigations
	)
	{
		$this->navigationsService = $navigations;
	}

	/**
	 * @param BaseForm $baseForm
	 *
	 * @return BaseContainer
	 */
	public function getFormContainer(BaseForm $baseForm)
	{
		$container = new BaseContainer();

		$navs         = [];
		$site         = $baseForm->getCustomData('loadComponent')['site'] ?: $baseForm->getValues()['site'];
		$otherAliases = [];

		foreach ($this->navigationsService->getEr()->createQueryBuilder('n')
			         ->select('n.id, nt.title, n.lvl, n.componentType, IDENTITY(n.site) as site, gt.title as group')
			         ->join('n.texts', 'nt', 'WITH', 'nt.lang = :lang AND nt.isPublished = 1')
			         ->leftJoin('n.group', 'g')
			         ->leftJoin('g.texts', 'gt', Join::WITH, 'gt.lang = :lang')
			         ->andWhere('n.lvl > 0')
			         ->andWhere('n.site = :site')
			         ->setParameters([
				         'lang' => $this->translator->getLocale(),
				         'site' => $site,
			         ])->orderBy('n.root')->addOrderBy('n.lft')
			         ->getQuery()->getArrayResult() as $v) {
			if ($v['componentType'] === self::TYPE) {
				$otherAliases[] = $v['id'];
			}

			$title = ' ' . $v['title'];
			for ($i = 1; $i < $v['lvl']; $i++) {
				$title = '---' . $title;
			}

			$navs[$v['group']][$v['id']] = trim($title);
		}

		$container->addSelect('navigation', 'default.navigationForm.navigation', $navs)
			->setDisabled($otherAliases)
			->setIsMultilanguage()
			->setRequired();
		$container->addText('urlSuffix', 'default.navigationForm.urlSuffix');

		return $container;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	public function presenterActionCheck($presenter, $action)
	{
		return false;
	}

	public function routerIn($params, $urlParams = [])
	{
		return null;
	}

	public function routerOut(DaoNavigationItem $navigation, &$urlParams): ?string
	{
		return null;
	}
}
