<?php declare(strict_types = 1);

namespace Core\Model\Notifiers\MailNotifiers;

use Contributte\Translation\Translator;
use Core\Model\Dao\Site;
use Core\Model\Notifiers\ILogNotifier;
use Core\Model\Parameters;
use Nette\Mail\Mailer;
use Nette\Mail\Message;
use Tracy\Debugger;

class LogNotifier implements ILogNotifier
{
	/** @var callable|null */
	public static $getUserEmails = null;

	public static ?string     $developersMail = null;
	public static ?Site       $site           = null;
	public static ?Translator $translator     = null;
	public static ?Mailer     $mailer         = null;

	public static function toDevelopers(string $message, ?string $subject = null, bool $useBaseEmail = false): void
	{
		if (static::$site) {
			$siteName = static::$site->getSiteName();
		} else {
			$siteName = $_SERVER['HTTP_HOST'] ?? '';
		}

		try {
			$msg = new Message;
			$msg->setFrom('noreply@pshk.cz', $siteName ?: Parameters::load('siteName'))
				->addTo($useBaseEmail ? Parameters::load('system.error.baseEmail') : static::$developersMail)
				->setSubject($siteName . ' - ' . ($subject ?: $message))
				->setHtmlBody($message);

			self::$mailer->send($msg);
		} catch (\Exception $e) {
			Debugger::log($e, '_logNotifierFailed');
		}
	}

	public static function toCustomer(string $message, ?string $subject = null): void
	{
		if (static::$site) {
			$siteName = static::$site->getSiteName();
		} else {
			$siteName = $_SERVER['HTTP_HOST'] ?? '';
		}

		try {
			$msg = new Message;
			$msg->setFrom(static::$site->email ?: 'noreply@pshk.cz', $siteName ?: Parameters::load('siteName'))
				->setSubject($subject ?: $message)
				->setHtmlBody($message);

			if (is_callable(static::$getUserEmails)) {
				foreach (call_user_func(static::$getUserEmails) as $email) {
					$msg->addTo($email);
				}
			}

			self::$mailer->send($msg);
		} catch (\Exception $e) {
			Debugger::log($e, '_logNotifierFailed');
		}
	}

	protected static function parseSubject(string $subject): string
	{
		if (static::$site) {
			$subject = str_replace(
				['%siteName%', '%siteDomain%'],
				[static::$site->getSiteName(), static::$site->getCurrentDomain()->getDomain()],
				$subject
			);
		}

		return $subject;
	}
}
