<?php declare(strict_types = 1);

namespace Core\Model\Router;

use Core\Model\Helpers\Arrays;
use Core\Model\Sites;
use Contributte\Translation\Translator;

class RouteHelper
{
	public static ?string $validatedLang = null;

	protected Translator $translator;
	protected Sites      $sites;

	protected array $translation;

	public function __construct(
		array      $translation,
		Translator $translator,
		Sites      $sites
	)
	{
		$this->sites       = $sites;
		$this->translation = $translation;
		$this->translator  = $translator;
	}

	/**
	 * @param array|string|\Closure $metadata
	 */
	public function createRoute(string $mask, $metadata = [], int $flags = 0, ?string $locale = null): Route
	{
		$domainLangs = array_keys($this->sites->getCurrentSite()->getDomains());
		$langs       = array_intersect($this->translation['whitelist'], $domainLangs);

		if (self::$validatedLang) {
			$locale = self::$validatedLang;
		}

		if (!$locale || ($langs && !Arrays::contains($langs, $locale))) {
			$locale = $this->translation['default'];
		}

		$this->translator->setLocale($locale);

		return new Route($mask, $metadata, $flags, count($langs) <= 1 ? null : $locale);
	}

	/**
	 * @param array|string|\Closure $metadata
	 */
	public function createAdminRoute(string $mask, $metadata = [], int $flags = 0, ?string $locale = null): RouteAdmin
	{
		$langs = $this->translation['whitelist'];

		if (!$locale || !Arrays::contains($langs, $locale)) {
			$locale = $this->translation['default'];
		}

		$this->translator->setLocale($locale);

		return new RouteAdmin($mask, $metadata, $flags, $locale);
	}
}
