<?php declare(strict_types = 1);

namespace Core\Model\TemplateReader\Providers;

abstract class TemplateTextType
{
	/** @var string */
	protected $type;

	/** @var string */
	protected $name;

	/** @var string */
	protected $title;

	/** @var mixed|null */
	protected $default = null;

	protected string $wrapEl     = 'div class=form-group';
	protected string $labelEl    = 'label';
	protected string $inputClass = 'form-control';

	public function getType(): string { return $this->type; }

	public function setTitle(string $title): void { $this->title = $title; }

	public function getTitle(): string { return $this->title; }

	public function setName(string $name): void { $this->name = $name; }

	public function getName(): string { return $this->name; }

	/**
	 * @param mixed|null $default
	 */
	public function setDefault($default): void
	{
		$this->default = $default;
	}

	/**
	 * @return mixed
	 */
	public function getDefault() { return $this->default; }
}
