<?php declare(strict_types = 1);

namespace Core\Model\Translation;

use Core\Model\Entities\EntityManagerDecorator;

class FieldLockerService
{
	protected EntityManagerDecorator $em;

	protected ?array $lockedFields = null;

	public function __construct(
		EntityManagerDecorator $em
	)
	{
		$this->em = $em;
	}

	public function getLockedFields(): array
	{
		if ($this->lockedFields === null) {
			$this->lockedFields = [];

			foreach ($this->em->getConnection()->fetchAllAssociative("SELECT `key` FROM core__translate_field WHERE is_locked = 1") as $row) {
				$this->lockedFields[$row['key']] = 1;
			}
		}

		return $this->lockedFields;
	}

	public function getLocked(string $key, string $locale): bool
	{
		return $this->em->getConnection()->fetchOne("SELECT is_locked FROM core__translate_field WHERE `key` = :key AND `locale` = :locale", [
				'key'    => $key,
				'locale' => $locale,
			]) === 1;
	}

	public function saveData(string $key, string $locale, bool $locked): bool
	{
		try {
			$this->em->getConnection()->executeQuery("INSERT INTO core__translate_field (`key`, `locale`, is_locked) 
				VALUES (:key, :locale, :locked)
				ON DUPLICATE KEY UPDATE is_locked = :locked", [
				'key'    => $key,
				'locale' => $locale,
				'locked' => $locked ? 1 : 0,
			]);

			return true;
		} catch (\Exception $e) {
		}

		return false;
	}
}
