<?php declare(strict_types = 1);

namespace Core\Model\Translation;

use DeepL\Usage;
use Tracy\Debugger;

class TextTranslator
{
	protected DeepLApi $deepLApi;

	public function __construct(
		DeepLApi $deepLApi
	)
	{
		$this->deepLApi = $deepLApi;
	}

	public function translateTextMulti(array $texts, string $sourceLang, string $targetLang): array
	{
		try {
			$result = $this->deepLApi->translateText($texts, $sourceLang, $targetLang);

			return is_string($result) ? [$result] : $result;
		} catch (\Exception $e) {
			Debugger::log($e, 'translateText');

			throw $e;
		}
	}

	public function translateHtmlMulti(array $texts, string $sourceLang, string $targetLang): array
	{
		try {
			$result = $this->deepLApi->translateHtml($texts, $sourceLang, $targetLang);

			return is_string($result) ? [$result] : $result;
		} catch (\Exception $e) {
			Debugger::log($e, 'translateText');

			throw $e;
		}
	}

	public function translateText(string $text, string $sourceLang, string $targetLang, bool $throw = false): ?string
	{
		try {
			return $this->deepLApi->translateString($text, $sourceLang, $targetLang);
		} catch (\Exception $e) {
			Debugger::log($e, 'translateText');

			if ($throw) {
				throw $e;
			}
		}

		return null;
	}

	public function translateHtml(string $text, string $sourceLang, string $targetLang, bool $throw = false): ?string
	{
		try {
			return $this->deepLApi->translateString($text, $sourceLang, $targetLang);
		} catch (\Exception $e) {
			Debugger::log($e, 'translateHtml');

			if ($throw) {
				throw $e;
			}
		}

		return null;
	}

	public function getUsage(): ?Usage
	{
		try {
			return $this->deepLApi->getUsage();
		} catch (\Exception $e) {
			Debugger::log($e, 'deepl-checkUsage');
		}

		return null;
	}
}
