<?php declare(strict_types = 1);

namespace Core\Model;

class WebColors
{
	protected static array $cColors = [];

	protected Settings $settings;

	public function __construct(Settings $settings)
	{
		$this->settings = $settings;
	}

	public function clearCache(): void
	{
		$this->settings->clearCache();
		self::$cColors = [];
	}

	public function getColors(string $siteIdent = ''): array
	{
		$siteIdent = $siteIdent === '' ? $siteIdent : $siteIdent . '_';

		if (!array_key_exists($siteIdent, self::$cColors)) {
			self::$cColors[$siteIdent] = $this->settings->getPrefixed($siteIdent . 'webColors') ?: [];
		}

		return self::$cColors[$siteIdent];
	}
}
