import SimpleBar            from 'simplebar';
import naja                 from "naja";
import {Utilities}          from "core/front/src/js/utils/utilities";
import addStylesToShadowDOM from "vue-style-loader/lib/addStylesShadow";
import Pickr                from "@simonwep/pickr";
import NestedLists          from './utils/NestedLists';
import SortableLists        from './utils/SortableLists';
import NavTabs              from './utils/NavTabs';

naja.historyHandler.uiCache = false;
naja.history                = false;
naja.uiHandler.selector     = '';
window.naja                 = naja;
global.naja                 = window.naja;

// Kousky CK editoru před kompletní změnou
document.ckEditorExtraPlugins =
	'panelbutton,button,floatpanel,panel,justify,colorbutton,font,filemanager,lineheight,readmore,wordcount';

// TODO staré řešení JS volá metodu v ajaxComplete. Při předělávání nezapomenou se napojit na najaComplete
window.fileRequest = (fileRequests) => {
	if (fileRequests === undefined)
		return;

	for (let i in fileRequests) {
		window.open(fileRequests[i].url, fileRequests[i].name);
	}
};

global.naja.addEventListener('before', e => {
	let loadingOverlay = document.getElementById('loading-overlay');

	if (loadingOverlay !== null) {
		loadingOverlay.dataset.count = parseInt(loadingOverlay.dataset.count) + 1;
	} else {
		document.getElementsByTagName('BODY')[0].insertAdjacentHTML('beforeend', '<div id="loading-overlay" data-count="1">' +
			'<div class="spinner">' +
			'<div class="rect1"></div>' +
			'<div class="rect2"></div>' +
			'<div class="rect3"></div>' +
			'<div class="rect4"></div>' +
			'<div class="rect5"></div>' +
			'</div></div>');
	}
});

global.naja.addEventListener('complete', e => {
	let loadingOverlay = document.getElementById('loading-overlay');

	if (loadingOverlay) {
		if (loadingOverlay.dataset.count > 1)
			loadingOverlay.dataset.count = parseInt(loadingOverlay.dataset.count) - 1;
		else
			loadingOverlay.parentNode.removeChild(loadingOverlay);
	}
});

document.addEventListener('DOMContentLoaded', () => {
	const nestedLists   = new NestedLists;
	const sortableLists = new SortableLists;
	const navTabs       = new NavTabs;

	document.querySelectorAll('[data-simplebar]').forEach(el => {
		new SimpleBar(el);
	});

	setSiteSelectByActiveTab();
	initBoolSwitcherControl();
	initDataTextToggle();
	initDataGridNestedListChange();
	initColorPicker();
	checkSwitchesHighlight();
	initDataLinkOnChange();

	// Kvůli kompatibilitě s jquery
	window.jQuery(document).ajaxComplete(function (event, xhr, settings) {
		nestedLists.init();
		sortableLists.init();
		navTabs.init();
		initBoolSwitcherControl();
		initDataTextToggle();
		initDataGridNestedListChange();
		initColorPicker();
		checkSwitchesHighlight();
		setSiteSelectByActiveTab();
		initDataLinkOnChange();
	});

	global.naja.addEventListener('complete', e => {
		nestedLists.init();
		sortableLists.init();
		navTabs.init();
		initBoolSwitcherControl();
		initDataTextToggle();
		initDataGridNestedListChange();
		initColorPicker();
		checkSwitchesHighlight();
		setSiteSelectByActiveTab();
		initDataLinkOnChange();
	});

	document.addEventListener('shownBsModal', e => {
		checkSwitchesHighlight();
	});

	document.addEventListener('click', e => {
		let target = e.target;

		/**
		 * Přepínač addBool
		 */
		if (target.classList.contains('switch__input')) {
			switchHighlightValue(target.parentElement);
		}
	});
});

const setSiteSelectByActiveTab = () => {
	let activeSite = document.querySelector('.tab-content__panel.active');
	if (activeSite) {
		activeSite = activeSite.dataset.site;

		if (!activeSite)
			return;

		document.querySelectorAll('[name="site"]:not([data-changed-by-tab])').forEach(input => {
			input.setAttribute('data-changed-by-tab', true);

			if (input.value == activeSite)
				return;

			setTimeout(() => {
				input.value = activeSite;
				input.dispatchEvent(new Event('change', {
					bubbles: true,
				}));
			}, 300);
		});
	}
}

const checkSwitchesHighlight = () => {
	document.querySelectorAll('.switch').forEach(switcher => {
		switchHighlightValue(switcher);
	});
}

// Přepínač addBool - zvýraznění zvolené hodnoty
const switchHighlightValue = (switcher) => {
	let switcherLeftOffset = switcher.getBoundingClientRect().left;

	if (switcher.classList.contains('switch--bool')) {
		let input        = switcher.querySelector('input');
		let boolWatchers = document.querySelectorAll('[data-watch-bool-input="' + input.id + '"]');
		let checked      = input.checked;
		let itemSuccess  = switcher.querySelector('.switch__item-1');
		let itemDanger   = switcher.querySelector('.switch__item-0');

		if (checked) {
			itemSuccess.classList.remove('bg-danger');
			itemDanger.classList.add('bg-success');

			boolWatchers.forEach(watcher => {
				watcher.classList.add('bg-success');
				watcher.classList.remove('bg-danger');
			})
		} else {
			itemDanger.classList.remove('bg-success');
			itemSuccess.classList.add('bg-danger');

			boolWatchers.forEach(watcher => {
				watcher.classList.remove('bg-success');
				watcher.classList.add('bg-danger');
			})
		}

		return;
	}

	if (switcherLeftOffset === 0)
		return;

	try {
		let checked = switcher.querySelector('input:checked').nextElementSibling;

		if (checked) {
			let slide = switcher.querySelector('.switch__slide');

			slide.classList.remove('bg-' + slide.dataset.bg);
			slide.classList.add('bg-' + checked.dataset.bg);
			slide.dataset.bg  = checked.dataset.bg;
			slide.style.left  = (checked.getBoundingClientRect().left - switcherLeftOffset + 2) + 'px';
			slide.style.width = (checked.offsetWidth - 4) + 'px';
		}
	} catch (e) {
		console.error(e);
	}
}

// bool switcher
const initBoolSwitcherControl = () => {
	document.querySelectorAll('.bool-switcher-control label:not(.init)').forEach(label => {
		label.classList.add('init');
		label.addEventListener('click', e => {
			let siblings = Utilities.getSiblings(label);

			siblings.forEach(sib => {
				sib.setAttribute('class', 'btn btn-outline-' + sib.dataset.btnClass);
			});

			label.setAttribute('class', 'btn btn-' + label.dataset.btnClass);
		});
	});
};

const initDataTextToggle = () => {
	document.querySelectorAll('[data-text-toggle]:not(.init)').forEach(el => {
		el.classList.add('init');
		el.addEventListener('click', e => {
			let tmp = el.textContent.trim();

			el.textContent        = el.dataset.textToggle.trim();
			el.dataset.textToggle = tmp;
		});
	});
};

const initDataGridNestedListChange = () => {
	document.querySelectorAll('.datagrid .nested-list input:not(.init)').forEach(input => {
		input.classList.add('init');

		input.addEventListener('change', e => {
			global.naja.uiHandler.submitForm(input.form);
		});
	});
};

// Init color pickeru
const initColorPicker = () => {
	document.querySelectorAll('[data-color-input="wrap"]:not(.init)').forEach(wrap => {
		wrap.classList.add('init');
		let input = wrap.querySelector('[data-color-input="input"]');

		let pickr = Pickr.create({
			el        : wrap.querySelector('[data-color-input="btn"]'),
			theme     : 'classic',
			default   : input.value || '#2AABE2',
			swatches  : [
				'#4c99ca',
				'#f5b252',
				'#30e4ef',
				'#4c4949',
				'#ff0000',
				'#f6f6f6',
				'#a1a1a1',
				'#cacaca',
				'#464444',
				'#39b54a',
				'#dadee0',
				'#8f8b8b',
			],
			components: {
				preview    : true,
				opacity    : true,
				hue        : true,
				interaction: {
					hex  : true,
					rgba : true,
					hsla : true,
					hsva : false,
					cmyk : false,
					input: true,
					clear: true,
					save : true
				}
			},
			strings   : {
				save : wrap.dataset.colorPickerTextSave,
				clear: wrap.dataset.colorPickerTextClear,
			}
		}).on('save', (color, instance) => {
			input.value = color ? color.toHEXA().toString() : '';
			instance.hide();
		});

		input.addEventListener('focus', e => {
			input.blur();
			pickr.show();
			setTimeout(() => {
				pickr.getRoot().interaction.result.focus();
			}, 200);
		});
	});
};

const initDataLinkOnChange = () => {
	document.querySelectorAll('[data-link-on-change]:not(.init)').forEach(el => {
		el.classList.add('init');
		el.addEventListener('change', e => {
			e.preventDefault();
			e.stopPropagation();

			const link = el.dataset.linkOnChange.replace('__val__', el.value);

			global.naja.makeRequest('post', link, {}, {
				history: false,
			});
		});
	});
};
