export default class NavTAbs {
	constructor() {
		this.list = [];
		this.init();
	}

	init() {
		document.querySelectorAll('.nav-tabs:not(.init)').forEach(el => {
			el.classList.add('init');
			this.list.push(new NavTab(el));
		});
	};
}

class NavTab {
	constructor(wrap) {
		const self = this;
		this.wrap = wrap;
		this.links = this.wrap.querySelectorAll('.nav-tabs__link');
		this.tabs = [];

		this.links.forEach(link => {
			let tabId = self.getLinkId(link);
			this.tabs[tabId] = document.getElementById(tabId);
		});

		this.wrap.querySelectorAll('.nav-tabs__link').forEach(link => {
			link.addEventListener('click', e => {
				e.preventDefault();
				self.clearActive();

				link.classList.add('active');

				let tabContent = self.tabs[self.getLinkId(link)];
				if (tabContent)
					tabContent.classList.add('active');

			});
		});
	}

	getLinkId(link) {
		return link.getAttribute('href').substr(1);
	}

	clearActive() {
		this.links.forEach(el => {
			el.classList.remove('active');
		});

		for (let i in this.tabs)
			this.tabs[i].classList.remove('active');
	}
}
