<?php declare(strict_types = 1);

namespace Core\AdminModule\Components\WebColors;

use Core\AdminModule\Components\SettingsForm;
use Core\AdminModule\Model\ColorsCompiler;
use Core\Model\UI\Form\BaseForm;
use Nette\Utils\ArrayHash;

class ColorsForm extends SettingsForm
{
	/** @var string */
	protected $siteIdent;

	/** @var ColorsCompiler @inject */
	public $colorsCompiler;

	public function __construct(string $siteIdent)
	{
		$this->siteIdent       = $siteIdent;
		$this->inputNamePrefix = $siteIdent;
		parent::__construct('webColors');
	}

	public function render()
	{
		parent::render();
		$this->template->render();
	}

	protected function createComponentForm(): BaseForm
	{
		$form = parent::createComponentForm();

		$form['submit']->caption = 'core.colorsForm.saveAndApplyColors';

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): bool
	{
		$result    = parent::formSuccess($form, $values);
		$presenter = $this->getPresenter();

		if ($result) {
			if ($this->colorsCompiler->compile($this->siteIdent)) {
				$presenter->flashMessageSuccess('core.colorsCompiled');
			} else {
				$presenter->flashMessageDanger('core.colorsCompileError');
			}

			$presenter->redrawControl('flashes');
		}

		return $result;
	}
}
