<?php declare(strict_types = 1);

namespace Core\AdminModule\Presenters;

use Core\AdminModule\Components\Navigation\INavigationFactory as INavigationSidebarFactory;
use Core\AdminModule\Components\Navigation\Navigation as NavigationSidebar;
use Core\AdminModule\Model\Sites;
use Core\Components\Navigation\INavigationFactory;
use Core\Components\Navigation\Navigation;
use Core\Model\UI\TUITemplate;
use Kdyby\Doctrine\EntityManager;

/**
 * Class BasePresenter
 * @package Core\AdminModule\Presenters
 */
abstract class BasePresenter extends CustomBasePresenter
{
	use TUITemplate;

	/** @var EntityManager @inject */
	public $em;

	/** @var Sites @inject */
	public $sitesService;

	protected function startup()
	{
		parent::startup();
		$this->getHttpResponse()->setHeader('Content-Security-Policy', '');
	}

	public function checkRequirements($element)
	{
		parent::checkRequirements($element);
		if (!$this->getUser()->isLoggedIn() && $this->getName() != 'Users:Admin:Login')
			$this->forward(':Users:Admin:Login:');
		if ($this->getUser()->isLoggedIn() && !$this->getUser()->getIdentity()->isActive) {
			$this->getUser()->logout(true);
			$this->redirect(':Users:Admin:Login:');
		}
	}

	/*******************************************************************************************************************
	 * =============================== Render
	 */

	public function beforeRender()
	{
		parent::beforeRender();

		$this['meta']->setMeta('robots', 'noindex, nofollow');

		$js = [];
		foreach (glob(ASSETS_DIR . '/admin2/js-autoload/*.js') as $file) {
			$js[] = [
				'file' => str_replace(WWW_DIR, '', $file),
				'v'    => filemtime($file),
			];
		}
		$this->template->autoloadJs = $js;

		if (file_exists(TEMPLATES_DIR . '/Admin/default/favicon.latte'))
			$this->template->faviconFile = TEMPLATES_DIR . '/Admin/default/favicon.latte';

		$this->template->sites = $this->sitesService->getAll();
	}

	/*******************************************************************************************************************
	 * =============================== Handle
	 */

	public function handleLogout()
	{
		$this->getUser()->logout(true);
		$this->redirect(':Dashboard:Admin:Default:');
	}

	/*******************************************************************************************************************
	 * =============================== Components
	 */

	protected function createComponentNavigationSidebar(INavigationSidebarFactory $factory): NavigationSidebar
	{
		return $factory->create();
	}

	protected function createComponentNavigation(INavigationFactory $factory): Navigation
	{
		$control = $factory->create();

		return $control;
	}

	/*******************************************************************************************************************
	 * =============================== Get / Set
	 */
}
