<?php declare(strict_types = 1);

namespace Core\FrontModule\Model;

use Core\Model\Sites;

class SeoParser
{
	/** @var Sites */
	protected $sites;

	public function __construct(Sites $sites)
	{
		$this->sites = $sites;
	}

	/**
	 * @param string $string
	 *
	 * @return string
	 */
	public function parse(string $string): string
	{
		$site   = $this->sites->getCurrentSite();
		$string = str_replace(
			['$siteName', '$separator'],
			[$site->getSiteName(), $site->getSiteNameSeparator()],
			$string
		);
		$string = trim($string);

		return $string;
	}
}
