<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Core\Model\Helpers\Strings;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="core__site")
 * @ORM\Entity
 */
class Site
{
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Id
	 * @ORM\Column(name="ident", type="string", length=255, nullable=false)
	 */
	protected $ident;

	/**
	 * @var SiteText[]
	 * @ORM\OneToMany(targetEntity="SiteText", mappedBy="site", indexBy="lang")
	 */
	public $texts;

	/**
	 * @var string
	 * @ORM\Column(name="logo", type="string", length=255, nullable=true)
	 */
	public $logo;

	/**
	 * @var string
	 * @ORM\Column(name="site_name_separator", type="string", length=255, nullable=true)
	 */
	public $siteNameSeparator;

	/**
	 * @var string
	 * @ORM\Column(name="email", type="string", length=255, nullable=true)
	 */
	public $email;

	public function __construct(string $ident)
	{
		$this->setIdent($ident);
		$this->texts = new ArrayCollection();
	}

	public function setIdent(string $ident): self
	{
		$this->ident = Strings::webalize($ident);

		return $this;
	}

	public function getIdent(): string { return $this->ident; }

	public function setTexts(array $texts): self
	{
		$this->texts = new ArrayCollection($texts);

		return $this;
	}
}
