<?php declare(strict_types = 1);

namespace Core\Model\Helpers;

use Nette\Application\UI\Presenter;
use Nette\Caching\Cache;
use Nette\Caching\Storages\FileStorage;
use Nette\ComponentModel\Component;
use Nette\Utils\FileSystem;

class CacheHelper
{
	/** @var null|Cache */
	protected static $cTemplatesCache = null;

	public static function getComponentKey(Presenter $presenter, Component $component, string $filename): string
	{
		return Strings::webalize($presenter->getName() . '-' . $component->lookupPath() . '-' . $filename);
	}

	public static function getTemplatesCache(): Cache
	{
		if (static::$cTemplatesCache === null) {
			$path = TMP_DIR . '/cache/templatePaths';
			FileSystem::createDir($path);
			static::$cTemplatesCache = new Cache(new FileStorage($path));
		}

		return static::$cTemplatesCache;
	}
}
