<?php declare(strict_types = 1);

namespace Core\Model\Helpers;

use Doctrine\Common\Collections\Collection;
use Nette\ComponentModel\IContainer;
use Nette\Forms\Controls\SelectBox;

class FormHelper
{
	public static function fillContainerByEntity(IContainer &$container, $entity): void
	{
		foreach ($container->getControls() as $input) {
			$name = $input->getName();

			if (!isset($entity->$name) || $entity->$name instanceof Collection)
				continue;

			if ($input instanceof SelectBox) {
				if (array_key_exists($entity->$name, $input->getItems()))
					$input->setDefaultValue($entity->$name);
			} else {
				$input->setDefaultValue($entity->$name);
			}
		}
	}

	public static function fillEntityByValues(&$entity, $values): void
	{
		foreach ($values as $k => $v) {
			if (!property_exists($entity, $k) || $entity->$k instanceof Collection)
				continue;

			$entity->$k = $v;
		}
	}
}
