<?php declare(strict_types = 1);

namespace Core\Model\Navigation;

use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Entities\Navigation;
use Navigations\AdminModule\Model\Navigations;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;

class Alias extends BaseNavigation implements INavigationItem
{
	protected $title = 'alias';

	/** @var Navigations */
	protected $navigationsService;

	public function __construct(Navigations $navigations)
	{
		$this->navigationsService = $navigations;
	}

	/**
	 * @param BaseForm $baseForm
	 *
	 * @return BaseContainer
	 */
	public function getFormContainer(BaseForm $baseForm)
	{
		$container = new BaseContainer();

		$navs = [];
		foreach ($this->navigationsService->getEr()->createQueryBuilder('n')
			         ->select('n.id, nt.title, n.lvl')
			         ->join('n.texts', 'nt', 'WITH', 'nt.lang = :lang AND nt.isPublished = 1')
			         ->andWhere('n.componentType != :cp')
			         ->andWhere('n.lvl > 0')
			         ->setParameters([
				         'cp'   => 'navigation.alias',
				         'lang' => $this->translator->getLocale(),
			         ])->orderBy('n.root')->addOrderBy('n.lft')
			         ->getQuery()->getArrayResult() as $v) {
			$title = ' ' . $v['title'];
			for ($i = 1; $i < $v['lvl']; $i++)
				$title = '---' . $title;
			$navs[$v['id']] = trim($title);
		}

		$container->addSelect('navigation', 'default.navigationForm.navigation', $navs)->setRequired();

		return $container;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	public function presenterActionCheck($presenter, $action)
	{
		return false;
	}

	public function routerIn($params, $urlParams = [])
	{
		return null;
	}

	public function routerOut(DaoNavigationItem $navigation, &$urlParams): ?string
	{
		return null;
	}
}
