<?php declare(strict_types = 1);

namespace Core\Model\Router;

use Core\Model\Lang\DefaultLang;
use Core\Model\Lang\Langs;
use Nette\Localization\ITranslator;

/**
 * Class RouteHelper
 * @package Core\Model\Router
 */
class RouteHelper
{
	/** @var DefaultLang */
	protected $defaultLang;

	/** @var Langs */
	protected $langsService;

	/** @var ITranslator */
	protected $translator;

	public function __construct(DefaultLang $defaultLang, Langs $langs, ITranslator $translator)
	{
		$this->defaultLang  = $defaultLang;
		$this->langsService = $langs;
		$this->translator   = $translator;
	}

	public function createRoute($mask, $metadata = [], $flags = 0, $locale = null)
	{
		if (!$locale || !array_key_exists($locale, $this->langsService->getLangs(false))) {
			$locale = $this->defaultLang->default;
		}

		$this->translator->setLocale($locale);

		return new Route($mask, $metadata, $flags, $locale);
	}

	public function createAdminRoute($mask, $metadata = [], $flags = 0, $locale = null)
	{
		if (!$locale || !array_key_exists($locale, $this->langsService->getLangs(false))) {
			$locale = $this->defaultLang->default;
		}

		$this->translator->setLocale($locale);

		return new RouteAdmin($mask, $metadata, $flags, $locale);
	}
}
