<?php declare(strict_types = 1);

namespace Core\Model\Templating;

use Contributte\Application\LinkGenerator;
use Contributte\EventDispatcher\EventDispatcher;
use Core\Model\Event\TemplateFactoryEvent;
use Core\Model\Images\ImagePipe;
use Core\Model\Lang\Langs;
use Core\Model\Settings;
use Core\Model\Sites;
use Core\Model\WebColors;
use Nette;
use Nette\Application\UI;
use Nette\Bridges\ApplicationLatte\ILatteFactory;
use Nette\Caching\IStorage;
use Nette\Http\IRequest;
use Nette\Security\User;
use Nette\Localization\ITranslator;

final class TemplateFactory extends Nette\Bridges\ApplicationLatte\TemplateFactory
{
	/** @var array */
	protected $support;

	/** @var ImagePipe */
	protected $imagePipe;

	/** @var LinkGenerator */
	protected $linkGenerator;

	/** @var Langs */
	protected $langs;

	/** @var Settings */
	protected $settings;

	/** @var Sites */
	protected $sites;

	/** @var ITranslator */
	protected $translator;

	/** @var WebColors */
	protected $webColors;

	/** @var EventDispatcher */
	protected $eventDispatcher;

	public function __construct($support, ILatteFactory $latteFactory, ITranslator $translator, IRequest $httpRequest = null, User $user = null,
	                            IStorage $cacheStorage = null, $templateClass = null, ImagePipe $imagePipe, LinkGenerator $linkGenerator,
	                            Settings $settings, Langs $langs, Sites $sites, WebColors $webColors, EventDispatcher $eventDispatcher)
	{
		parent::__construct($latteFactory, $httpRequest, $user, $cacheStorage, $templateClass);
		$this->support         = $support;
		$this->imagePipe       = $imagePipe;
		$this->linkGenerator   = $linkGenerator;
		$this->langs           = $langs;
		$this->settings        = $settings;
		$this->translator      = $translator;
		$this->sites           = $sites;
		$this->webColors       = $webColors;
		$this->eventDispatcher = $eventDispatcher;
	}

	public function createTemplate(UI\Control $control = null)
	{
		$template = parent::createTemplate($control);

		$site = $this->sites->getCurrentSite();

		$template->_imagePipe     = $this->imagePipe;
		$template->linkGenerator  = $this->linkGenerator;
		$template->support        = $this->support;
		$template->currentSite    = $site;
		$template->siteName       = $site->getSiteName();
		$template->adminAssets    = '/' . ASSETS_FOLDER . '/admin';
		$template->frontAssets    = '/' . ASSETS_FOLDER . '/front';
		$template->frontImages    = $template->frontAssets . '/img';
		$template->webSettings    = $this->settings->getAll();
		$template->langs          = $this->langs;
		$template->lang           = $this->translator->getLocale();
		$template->webColors      = $this->webColors->getColors($site->getIdent());
		$template->isMultiSiteWeb = count($this->sites->getSites()) > 1 ? true : false;
		$year                     = date('Y');
		$template->pshkCopyright  = '<div id="pshk-copyright">&copy; by <a href="https://www.pshk.cz" target="_blank">PSHK s.r.o.</a></div>';

		$this->eventDispatcher->dispatch(new TemplateFactoryEvent($template), 'templateFactory::createTemplate');

		return $template;
	}
}
