<?php declare(strict_types = 1);

namespace Core\Components\Header;

use Core\Model\UI\BaseControl;
use Nette\Utils\Html;

class Header extends BaseControl
{
	/** @var string */
	private $title;

	/** @var string */
	private $description;

	/** @var string */
	private $icon;

	public function render()
	{
		$this->template->title       = $this->title;
		$this->template->description = $this->description;
		$this->template->icon        = $this->icon;
		$this->template->setFile(__DIR__ . '/Header.latte');
		$this->template->render();
	}

	/**
	 * Nastavení všech informací potřebných pro header v adminu
	 *
	 * @param $icon
	 * @param $title
	 * @param $description
	 */
	public function setHeader($icon, $title, $description)
	{
		$this->icon        = $icon;
		$this->title       = $title;
		$this->description = $description;
	}

	/**
	 * @return string
	 */
	public function getTitle()
	{
		return $this->title;
	}

	/**
	 * @param string $title
	 */
	public function setTitle($title)
	{
		$this->title = $title;
	}

	/**
	 * @return string
	 */
	public function getDescription()
	{
		return $this->description;
	}

	/**
	 * @param string $description
	 */
	public function setDescription($description)
	{
		$this->description = $description;
	}

	/**
	 * @return string
	 */
	public function getIcon()
	{
		return $this->icon;
	}

	/**
	 * @param string $icon
	 */
	public function setIcon($icon)
	{
		$this->icon = $icon;
	}
}
