<?php declare(strict_types = 1);

namespace Core\Model\Navigation;

use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Entities\Navigation;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;

class CustomLink extends BaseNavigation implements INavigationItem
{
	protected $title = 'customLink';

	public function __construct()
	{
	}

	/**
	 * @return BaseContainer
	 */
	public function getFormContainer()
	{
		$container = new BaseContainer();

		$container->addText('link', 'default.navigationForm.link')->setRequired();

		return $container;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	public function presenterActionCheck($presenter, $action)
	{
		return false;
	}

	public function routerIn($params, $urlParams = [])
	{
		return ['remoteLink' => $params['link']];
	}

	public function routerOut(DaoNavigationItem $navigation, &$urlParams): ?string
	{
		if ($navigation instanceof DaoNavigationItem) {
			return $navigation->componentParams['link'] ?? null;
		}

		return null;
	}
}
