<?php declare(strict_types=1);

namespace Core\Model\Notifiers\MailNotifiers;

use Core\Model\Notifiers\ILogNotifier;
use Nette\Mail\Message;
use Nette\Mail\SendmailMailer;

class LogNotifier implements ILogNotifier
{
	/** @var string */
	public static $developersMail;

	/** @var string */
	public static $siteName;

	/** @var string */
	public static $siteEmail;

	/** @var callable */
	public static $getUserEmails;

	/**
	 * @param string $subject
	 * @param string $message
	 */
	public static function toDevelopers(string $message, string $subject): void
	{
		$msg = new Message;
		$msg->setFrom(sprintf('%s <%s>', static::$siteName, static::$siteEmail))
			->addTo(static::$developersMail)
			->setSubject($subject)
			->setHtmlBody($msg);

		(new SendmailMailer)->send($msg);
	}

	/**
	 * @param string $message
	 * @param string $subject
	 */
	public static function toCustomer(string $message, string $subject): void
	{
		$msg = new Message;
		$msg->setFrom(sprintf('%s <%s>', static::$siteName, static::$siteEmail))
			 ->setSubject($subject)
			 ->setHtmlBody($message);

		foreach (call_user_func(static::$getUserEmails) as $email) {
			$msg->addTo($email);
		}

		(new SendmailMailer)->send($msg);
	}

}