<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Nette;
use Nette\Application\UI\ISignalReceiver;
use Nextras\Forms\Controls\Fragments\ComponentControlTrait;

/**
 * Inspired by Nextras\Forms\Controls\Typeahead
 */
class TagsInput extends TextInput implements ISignalReceiver
{
	use ComponentControlTrait {
		attached as componentControlAttached;
	}

	/** @var array */
	protected $values = [];

	/** @var Nette\Utils\Callback */
	protected $callback;

	/** @var Nette\Utils\Callback */
	protected $createCallback;

	public function __construct($label = null, $callback = null, $createCallback = null)
	{
		parent::__construct($label);
		$this->setCallback($callback);
		$this->setCreateCallback($createCallback);
	}

	public function getControl()
	{
		$control          = parent::getControl();
		$control->class[] = 'form-control form-control-lg';
		$control->attrs   += [
			'data-role'     => 'tagsinput',
			'data-defaults' => Nette\Utils\Json::encode($this->values),
		];
		if (!empty($this->placeholder)) {
			$control->setAttribute('placeholder', $this->placeholder);
		}

		return $control;
	}

	public function handleAutocomplete($q)
	{
		if ($this->callback)
			$this->getPresenter()->sendJson(Nette\Utils\Callback::invokeArgs($this->callback, [$q]));
	}

	public function handleCreate($value)
	{
		if ($this->createCallback)
			$this->getPresenter()->sendJson(Nette\Utils\Callback::invokeArgs($this->createCallback, [$value]));
	}

	protected function attached($component)
	{
		parent::attached($component);
		$this->componentControlAttached($component);
		if ($component instanceof Nette\Application\IPresenter) {
			$this->control->{'data-typeahead-url'} = $this->link('autocomplete!', ['q' => '__q__']);
			$this->control->{'data-create-url'}    = $this->link('create!', ['value' => '__value__']);
		}
	}

	public function setCallback($callback)
	{
		$this->callback = $callback;
	}

	public function setCreateCallback($callback)
	{
		$this->createCallback = $callback;
	}

	public function setDefaultValue($values)
	{
		$form = $this->getForm(false);
		if ($this->isDisabled() || !$form || !$form->isAnchored() || !$form->isSubmitted()) {
			$this->values = $values;
			$this->setValue(implode(',', array_map(function($v) { return $v['key']; }, $values)));
		}

		return $this;
	}

}
