const fs = require('fs');
const resolve = require('path').resolve;
const join = require('path').join;
const cp = require('child_process');
const os = require('os');

// get library path
const lib = resolve(__dirname, '../');

console.log("Installing frontend dependencies from installed CMS modules...");

fs.readdirSync(lib).forEach(mod => {
	const modPath = join(lib, mod);
	if (!fs.existsSync(join(modPath, 'package.json'))) return;
	console.log(`Installing dependecies for ${mod}...`);
	const npmCmd = os.platform().startsWith('win') ? 'npm.cmd' : 'npm';
	cp.spawn(npmCmd, ['i'], {env: process.env, cwd: modPath, stdio: 'inherit'})
});