import flatpickr from "flatpickr";
import {Czech}   from "flatpickr/dist/l10n/cs.js";
import Choices   from "choices.js";

const initDatePickers = () => {
	document.querySelectorAll('.datetimepicker, .datepicker').forEach(el => {
		const parentElement = el.parentElement;

		if (!el.closest('.flatpicker-wrap')) {
			let clearA = document.createElement('a');
			clearA.setAttribute('class', 'btn btn-xs btn-danger');
			clearA.setAttribute('href', 'javascript:;');
			clearA.setAttribute('data-clear', '');
			clearA.innerHTML = '<i class="fas fa-times"></i>';

			try {
				parentElement.classList.add('flatpicker-wrap');
				parentElement.insertBefore(clearA, parentElement.nextElementSibling);
				el.parentElement.appendChild(clearA);
			} catch (e) {
			}
		}

		el.addEventListener('click', e => {
			if (el.inited === true)
				return;
			let isDate = el.classList.contains('datepicker') || el.type === 'date';

			let options = {
				locale     : Czech,
				minDate    : el.dataset.min,
				maxDate    : el.dataset.max,
				time_24hr  : true,
				dateFormat : isDate ? 'd. m. Y' : 'd. m. Y - H:i',
				enableTime : !isDate,
				defaultDate: el.getAttribute('value'),
			}

			flatpickr(el, options);

			if (el.inited !== true) {
				el.inited = true;

				el._flatpickr.open();
			}

			el.inited = true;
		});

		let wrap = el.closest('.flatpicker-wrap');
		if (wrap) {
			let clearEl = wrap.querySelector('a');

			clearEl.addEventListener('click', e => {
				if (el.inited === true)
					el._flatpickr.clear();
				else
					el.value = '';
			});
		}
	})
}
const initTimePickers = () => {
	document.querySelectorAll('.timepicker').forEach(el => {
		el.addEventListener('click', e => {
			if (el.inited === true)
				return;

			let options = {
				locale     : Czech,
				minTime    : el.dataset.min,
				maxTime    : el.dataset.max,
				time_24hr  : true,
				dateFormat : 'H:i',
				enableTime : true,
				noCalendar : true,
				defaultDate: el.getAttribute('value'),
			}

			flatpickr(el, options);

			if (el.inited !== true) {
				el.inited = true;

				el._flatpickr.open();
			}

			el.inited = true;
		});

		let wrap = el.closest('.flatpicker-wrap');
		if (wrap) {
			let clearEl = wrap.querySelector('a');

			clearEl.addEventListener('click', e => {
				el._flatpickr.clear();
			});
		}
	})
}

const initSelectOne = () => {
	document.querySelectorAll('.nested-list').forEach(group => {
		let items = group.querySelectorAll('.nested-list__item');
		items.forEach(el => {
			let span = el.querySelector('.select-one');

			if (span) {
				span.addEventListener('click', e => {
					e.stopImmediatePropagation();

					group.querySelectorAll('.nested-list__item input:checked').forEach(input => {
						input.removeAttribute('checked');
						input.checked = false;
					});

					let input = span.nextElementSibling;

					input.checked = true;
					input.dispatchEvent(new Event('change'));

					return false;
				})
			}
		});
	});
}

let choicesIndex   = 0;
global.choicesList = global.choicesList || {};
const initChoices  = () => {
	document.querySelectorAll('.frm__type-select select:not([data-choice]), select.select--choice:not([data-choice]), .col-filters select:not([data-choice])').forEach(select => {
		if (select.style.display === 'none')
			return true;

		global.choicesList[choicesIndex] = new Choices(select, {
			loadingText   : '',
			noResultsText : '',
			noChoicesText : '',
			itemSelectText: '',
		});
		select.setAttribute('data-choices-index', choicesIndex);

		choicesIndex++;
	});
}

initDatePickers();
initTimePickers();
initSelectOne();
initChoices();

// Kvůli kompatibilitě s jquery
window.jQuery(document).ajaxComplete(function (event, xhr, settings) {
	initDatePickers();
	initTimePickers();
	initSelectOne();
	initChoices();
});

global.naja.addEventListener('complete', e => {
	initDatePickers();
	initTimePickers();
	initSelectOne();
	initChoices();
});

document.addEventListener('formInputsInit', e => {
	initChoices();
})

document.addEventListener('contentLangChange', e => {
	document.querySelectorAll('select[data-choice][data-content-lang]').forEach(el => {
		if (el.dataset.contentLang !== e.detail.lang)
			el.closest('.choices').style.display = 'none';
		else
			el.closest('.choices').style.display = 'block';
	})

	initChoices();
})
