export const addEventForChild = (parent, eventName, childSelector, cb) => {
	parent.addEventListener(eventName, function (event) {
		const clickedElement = event.target,
		      matchingChild  = clickedElement.closest(childSelector);
		if (matchingChild) cb(matchingChild)
	})
};

export function switchClass(element, className) {
	if (element.classList.contains(className)) {
		element.classList.remove(className);
	} else {
		element.classList.add(className);
	}
}

export async function getJson(url) {
	let response = await fetch(url);
	let data     = await response.json();
	return data;
}
