import {tns} from "tiny-slider/src/tiny-slider";

export const PromoteApplet = (promoteAppletSlider) => {
	if (promoteAppletSlider) {
		const slider = tns({
			container           : promoteAppletSlider,
			items               : 1,
			controls            : false,
			autoplay            : true,
			autoplayTimeout     : 5000,
			edgePadding         : 0,
			mouseDrag           : true,
			autoplayButtonOutput: false,
			autoplayHoverPause  : true,
		});

		slider.events.on('indexChanged', (el) => {
			const realIndex = el.displayIndex;
			setActiveSliderItem(realIndex);
			const els = promoteAppletSlider.querySelector('.tns-nav-active');
		});

		document.querySelector('.promote-applet__arrow--right').addEventListener('click', () => {
			slider.pause();
			slider.goTo('next');

			if (window.lazyLoadInstance)
				window.lazyLoadInstance.update();
		});

		document.querySelector('.promote-applet__arrow--left').addEventListener('click', () => {
			slider.pause();
			slider.goTo('prev');

			if (window.lazyLoadInstance)
				window.lazyLoadInstance.update();
		});

		/**
		 * Ovladani slideru pomoc menu
		 */
		const promoteAppletMenuItems = document.querySelectorAll('.promote-applet__menu-item');
		promoteAppletMenuItems.forEach((el) => {
			el.addEventListener('click', () => {
				const id = parseInt(el.dataset.id) - 1;
				slider.pause();
				slider.goTo(id);

				if (window.lazyLoadInstance)
					window.lazyLoadInstance.update();
			});
		});
	}
};

const setActiveSliderItem = (id) => {
	const promoteAppletMenuItems = document.querySelectorAll('.promote-applet__menu-item');
	promoteAppletMenuItems.forEach(el => el.classList.remove('primary-bg-color'));
	const activeElement = document.querySelector(`.promote-applet__menu-item[data-id="${id}"]`);
	activeElement.classList.add('primary-bg-color');
};
