<?php declare(strict_types = 1);

namespace Core\AdminModule\Presenters;

use Core\Model\FileRequests;
use Nette\Application\Responses\FileResponse;

class FileResponsePresenter extends BasePresenter
{
	/** @var FileRequests|null @inject */
	public ?FileRequests $fileRequests = null;

	protected function startup()
	{
		parent::startup();
	}

	/*******************************************************************************************************************
	 * ===============================  Render
	 */

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(string $data = '')
	{
		if (is_numeric($data)) {
			$fileRequest = $this->fileRequests->get($data);
			if ($fileRequest)
				$data = $fileRequest->getData();
		}

		$data = unserialize(base64_decode($data));

		if ($data['file'] && file_exists($data['file'])) {
			$basename      = $data['filename'] ?: basename($data['file']);
			$forceDownload = $data['download'] ?? false;
			$contentType   = $data['contentType'] ?? null;
			$this->sendResponse(new FileResponse($data['file'], $basename, $contentType, $forceDownload));
		}

		exit;
	}
}
