<?php declare(strict_types = 1);

namespace Core\Model;

abstract class Config
{
	/** @var array */
	protected static $params;

	/** @var string */
	protected static $separator = '.';

	/**
	 * SystemConfig constructor.
	 *
	 * @param $params
	 */
	public function __construct($params)
	{
		self::$params[get_called_class()] = $params;
	}

	public static function setParams($params)
	{
		self::$params[get_called_class()] = $params;
	}

	public static function addParams(array $params)
	{
		foreach ($params as $k => $v) {
			$keys    = explode(self::$separator, $k);
			$arr     = &self::$params[get_called_class()];
			$lastKey = array_pop($keys);

			foreach ($keys as $key) {
				if (!isset($arr[$key]))
					break;
				$arr = &$arr[$key];
			}

			$arr[$lastKey] = $v;
		}
	}

	/**
	 * @param string $key
	 * @param mixed  $default
	 *
	 * @return mixed|null
	 */
	public function get($key, $default = null)
	{
		return self::load($key, $default);
	}

	public static function load($key, $default = null)
	{
		$keys = explode(self::$separator, $key);
		$arr  = self::$params[get_called_class()] ?? [];

		foreach ($keys as $key) {
			if (!isset($arr[$key]))
				return $default;
			$arr = $arr[$key];
		}

		return $arr ?? $default;
	}

	public static function getTemplate(string $file): string
	{
		return APP_DIR . static::load('layouts.frontTemplatesPath') . DS . static::load('layouts.' . $file, $file . '.latte');
	}
}
