<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="core__extra_field", indexes={@ORM\Index(name="cef_base", columns={"section_name", "key"})})
 * @ORM\Entity
 */
class ExtraField
{
	use TId;

	/**
	 * @var string
	 * @ORM\Column(name="section_name", type="string", length=255, nullable=false)
	 */
	public $sectionName;

	/**
	 * @var string
	 * @ORM\Column(name="section_key", type="string", length=255, nullable=false)
	 */
	public $sectionKey;

	/**
	 * @var string
	 * @ORM\Column(name="`key`", type="string", length=255, nullable=false)
	 */
	public $key;

	/**
	 * @var string
	 * @ORM\Column(name="value", type="text", nullable=true)
	 */
	public $value;

	/**
	 * @var string
	 * @ORM\Column(name="lang", type="string", length=2, nullable=true)
	 */
	public $lang;

	public function __construct(string $key, $value = null)
	{
		$this->key   = $key;
		$this->value = $value;
	}
}
