<?php declare(strict_types = 1);

namespace Core\Model\Router;

use Core\Model\Sites;
use Nette\Localization\ITranslator;

/**
 * Class RouteHelper
 * @package Core\Model\Router
 */
class RouteHelper
{
	public static ?string $validatedLang = null;

	protected ITranslator $translator;

	protected Sites $sites;

	protected array $translation;

	public function __construct(array $translation, ITranslator $translator, Sites $sites)
	{
		$this->sites       = $sites;
		$this->translation = $translation;
		$this->translator  = $translator;
	}

	public function createRoute($mask, $metadata = [], $flags = 0, $locale = null)
	{
		$domainLangs = array_keys($this->sites->getCurrentSite()->getDomains());
		$langs       = array_intersect($this->translation['whitelist'], $domainLangs);

		if (self::$validatedLang)
			$locale = self::$validatedLang;
		if (!$locale || $langs && !in_array($locale, $langs)) {
			$locale = $this->translation['default'];
		}

		$this->translator->setLocale($locale);

		return new Route($mask, $metadata, $flags, count($langs) <= 1 ? null : $locale);
	}

	public function createAdminRoute($mask, $metadata = [], $flags = 0, $locale = null)
	{
		$langs = $this->translation['whitelist'];

		if (!$locale || !in_array($locale, $langs)) {
			$locale = $this->translation['default'];
		}

		$this->translator->setLocale($locale);

		return new RouteAdmin($mask, $metadata, $flags, $locale);
	}
}
