<?php declare(strict_types = 1);

namespace Core\Model\TemplateReader;

use Core\Model\Helpers\BaseService;
use Core\Model\TemplateReader\Providers\ITemplateTextType;

/**
 * Class TemplateTextTypesCollection
 * @package Core\Model\TemplateReader
 */
class TemplateTextTypesCollection extends BaseService
{

	/** @var ITemplateTextType[] */
	private $itemsList = [];

	/**
	 * @param $type
	 *
	 * @return null|ITemplateTextType
	 */
	public function getItemByType($type)
	{
		return $this->itemsList[$type] ?? null;
	}

	/**
	 * @return array|ITemplateTextType[]
	 */
	public function getItems()
	{
		return $this->itemsList;
	}

	/**
	 * Voláno při generování containeru
	 *
	 * @param ITemplateTextType[] $items
	 */
	public function setItems($items)
	{
		foreach ($items as $item) {
			/** @var $item ITemplateTextType */
			$this->itemsList[$item->getType()] = $item;
		}
	}
}
