<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Model\UI\Form\Traits\TInputExtend;
use Nette\Utils\Html;
use Nextras;

class DatePicker extends Nextras\FormComponents\Controls\DateControl
{
	use TInputExtend;

	/** @var string */
	protected $htmlFormat = 'd. m. Y';

	/** @var string */
	protected $htmlType = 'text';

	public function getControl(): Html
	{
		$wrapper = Html::el('div');
		$control = parent::getControl();

		$control->attrs['class'][] = 'datepicker form-control form-control-lg';
		$wrapper->addHtml($control);

		return $wrapper;
	}

}
