<?php

namespace Core\Model\UI\Form\Controls;

use Core\Model\FilesManager\FilesManager;
use Core\Components\FilesManager\FilesManager as FilesManagerComponent;
use Core\Model\UI\ControllerHelper;
use Gallery\AdminModule\Components\Image\IImagesPickerFactory;
use Nette\Application\UI\ITemplateFactory;
use Nette\Http\Request;
use Nette\Application\UI\ISignalReceiver;
use Nette\DI\Container;
use Nette\Http\Session;
use Nette\Utils\Callback;
use Nette\Utils\Html;
use Nette\Utils\Json;
use Core\Model\UI\Form\Traits\ComponentControlTrait;

/**
 * TODO setFormat a srovnání funkcí SET/GET
 *
 * Class EditorInput
 * @package Core\Model\UI\Form\Controls
 */
class EditorInput extends TextInput implements ISignalReceiver
{
	use ComponentControlTrait {
		attached as componentControlAttached;
	}

	protected static $assetsLoaded = false;

	/** @var FilesManager */
	public $filesManager;

	/** @var callback */
	public $albumImagesCallback;

	/** @var IImagesPickerFactory */
	protected $albumImagesPickerFactory;

	/** @var Container */
	private $container;

	/** @var FilesManagerComponent */
	private $controller;

	/** @var ControllerHelper */
	protected $controllerHelper;

	/** @var Session */
	protected $session;

	/** @var Request */
	protected $request;

	/** @var string */
	private $controllerName;

	/** @var string */
	private $toolbar = 'Basic';

	/** @var array */
	private $toolbarButtons = [];

	/** @var string */
	protected $styles;

	/** @var string */
	protected $height = 500;

	protected $width = 'auto';

	/** @var bool */
	protected $disableAutoP = true;

	/** @var array */
	protected $roots = [];

	/** @var ITemplateFactory */
	protected $templateFactory;

	public function __construct($label = null, FilesManager $filesManager, ControllerHelper $controllerHelper, Session $session, Request $request, ITemplateFactory $templateFactory)
	{
		parent::__construct($label);
		$this->setType('hidden');
		$this->filesManager     = $filesManager;
		$this->controllerHelper = $controllerHelper;
		$this->controller       = new FilesManagerComponent($this->filesManager, $session, $request);
		$this->session          = $session;
		$this->request          = $request;
		$this->templateFactory  = $templateFactory;
	}

	protected function attached($form): void
	{
		parent::attached($form);
		$this->controllerName = 'filesManagerController' . ucfirst($this->name);
		$currGroup            = $this->getForm()->getCurrentGroup();

		$this->getForm()->setCurrentGroup(null);
		if (!$this->form->getComponent($this->controllerName, false))
			$this->form->addComponent($this->controller, $this->controllerName);
		if (!$this->form->getComponent('controllerHelper', false))
			$this->form->addComponent($this->controllerHelper, 'controllerHelper');

		$this->getForm()->setCurrentGroup($currGroup);

		//		parent::attached($form);
		//		$this->componentControlAttached($form);
		//		$this->controller   = new FilesManagerComponent($this->filesManager);
		//		$this->controllerName = 'filesManagerController' . ucfirst($this->name);
		//		$this->addComponent($this->controller, $this->controllerName);
		////		dump($this->controller);
		//
		//		$currGroup            = $this->getForm()->getCurrentGroup();
		//
		//		$this->getForm()->setCurrentGroup(null);
		//		$this->getForm()->setCurrentGroup($currGroup);
	}

	public function handleElFinder()
	{
		$this->controller->render();
		//		$this->controller->handleShowModal('a');
		//		$this->filesManager->run();
	}

	public function getControl(): Html
	{
		$this->controller->setModal();
		$wrapper   = Html::el('');
		$hidden    = parent::getControl();
		$maxLength = null;

		$baseValue = $this->getValue();
		if ($baseValue instanceof \stdClass)
			$baseValue = (array) $baseValue;

		$editorIds = [];
		if ($this->getIsMultiLanguage()) {
			$editor = Html::el();
			foreach ($hidden->getChildren() as $hChild) {
				$inputId     = $hChild->getAttribute('id');
				$lang        = $hChild->attrs['data-content-lang'];
				$ckEditorId  = str_replace('-', '', $inputId) . 'Editor';
				$editorIds[] = ['input' => $inputId, 'editor' => $ckEditorId];
				$maxLength   = $hChild->getAttribute('maxlength');
				$editor->addHtml(Html::el('textarea', [
					'id'                => $ckEditorId,
					'class'             => 'ck_textarea',
					'data-content-lang' => $lang,
				])->addHtml($baseValue[$lang] ?? ''));
			}
		} else {
			$inputId     = $hidden->getAttribute('id');
			$ckEditorId  = str_replace('-', '', $inputId) . 'Editor';
			$editor      = Html::el('textarea', ['id' => $ckEditorId, 'class' => 'ck_textarea']);
			$editorIds[] = ['input' => $inputId, 'editor' => $ckEditorId];

			if ($baseValue)
				$editor->addHtml($baseValue);
		}

		$wrapper->addHtml($hidden);
		$wrapper->addHtml($editor);

//		if (!self::$assetsLoaded) {
//			$script = Html::el('script', ['src' => '/assets/admin/default/ckeditor/ckeditor.js']);
//			$wrapper->addHtml($script);
//
//			self::$assetsLoaded = true;
//		}

		if (!$this->controller->getParent()) {
			$this->getPresenter()->addComponent($this->controller, $this->controllerName);
			//			$this->getPresenter()->addComponent($this->controllerHelper, 'controllerHelper');
		}
		ob_start();
		$this->controller->render();
		$content = ob_get_clean();

		$latte = $this->templateFactory->createTemplate();
		$latte->setFile(__DIR__ . '/EditorInput.latte');
		$latte->setParameters([
			'time'            => time(),
			'editorIds'       => $editorIds,
			'controllerName'  => $this->controllerName,
			'albumImagesUrl'  => $this->controllerHelper->link('callback!', function() {
				$this->handleAlbumImages();
			}),
			'elFinderUrl'     => $this->controller->link('showModal!', [$this->controllerName]),
			'elFinderOnlyUrl' => $this->controller->getPresenter()->link(':Core:Admin:FilesManager:only'),
			'toolbar'         => $this->toolbar,
			'toolbarButtons'  => $this->toolbarButtons,
			'styles'          => $this->styles,
			'height'          => $this->height,
			'width'           => $this->width,
			'disableAutoP'    => (bool) $this->disableAutoP,
			'roots'           => Json::encode($this->roots),
			'maxLength'       => $maxLength,
		]);

		if ($this->albumImagesCallback)
			$latte->preparedAlbumId = Callback::invoke($this->albumImagesCallback);

		$wrapper->addHtml($latte->renderToString());
		$wrapper->addHtml($content);

		return $wrapper;
	}

	public function setContainer(Container $container)
	{
		$this->container = $container;
	}

	public function setToolbar($toolbar)
	{
		$this->toolbar = $toolbar;

		return $this;
	}

	public function setToolbarButtons($buttons)
	{
		$this->toolbarButtons = array_map(function($v) {
			return trim($v);
		}, explode(',', $buttons));

		return $this;
	}

	public function setStyles($styles)
	{
		$this->styles = $styles;

		return $this;
	}

	public function setHeight($height)
	{
		$this->height = $height;

		return $this;
	}

	public function setWidth($width)
	{
		$this->width = $width;

		return $this;
	}

	public function setDisableAutoP($disable = true)
	{
		$this->disableAutoP = $disable;

		return $this;
	}

	public function addRoot($path)
	{
		$this->roots[] = $path;
	}

	public static function register(\Nette\DI\Container $systemContainer)
	{
		$class = __CLASS__;
		\Nette\Forms\Container::extensionMethod("addEditor", function(
			\Nette\Forms\Container $container, $name, $caption
		) use ($class, $systemContainer) {
			/** @var EditorInput $comp */
			$comp = new $class($caption,
				$systemContainer->getByType(FilesManager::class, false),
				$systemContainer->getByType(ControllerHelper::class, false),
				$systemContainer->getByType(Session::class, false),
				$systemContainer->getByType(Request::class, false),
				$systemContainer->getByType(ITemplateFactory::class, false));

			$comp->albumImagesPickerFactory = $systemContainer->getByType(IImagesPickerFactory::class, false);
			$comp->container                = $systemContainer;
			//			$comp->container = $container;

			$container->addComponent($comp, $name);

			return $comp;
		});
	}

	/*******************************************************************************************************************
	 * ==================  Album images
	 */

	public function handleAlbumImages()
	{
		$control = $this->albumImagesPickerFactory->create();
		$control->setParent($this->getPresenter());
		$control->setByAlbum($this->request->getPost('albumId'));
		ob_start();
		$control->render();
		$content = ob_get_clean();
		$this->getPresenter()->sendJson($content);
	}

	public function setAlbumImagesCallback($callback)
	{
		$this->albumImagesCallback = $callback;

		return $this;
	}
}
