export default class NavTabs {
	constructor() {
		this.list = [];
		this.init();
	}

	init() {
		const self           = this;
		const lastRemembered = this.getRemembered();

		document.querySelectorAll('.nav-tabs:not(.init)').forEach(el => {
			el.classList.add('init');

			let tab                = new NavTab(el, this);
			let rememberLastActive = el.dataset.rememberLastActive;

			if (rememberLastActive) {
				tab.onClick.push((link, href) => {
					self.setLastActive(rememberLastActive, href);
				});
			}

			this.list.push(tab);
		});

		document.querySelectorAll('.nav-tabs[data-remember-last-active]').forEach(el => {
			let active = lastRemembered[el.dataset.rememberLastActive];

			if (active) {
				let target = document.querySelector('[href="#' + active + '"]');

				if (target)
					target.dispatchEvent(new Event('click'));
			}
		});
	};

	setLastActive(key, value) {
		let storage = this.getRemembered();

		storage[key] = value;

		this.saveRemembered(storage);
	}

	saveRemembered(data) {
		window.localStorage.setItem('adminNavTabsRemembered', JSON.stringify(data));
	}

	getRemembered() {
		let storage = window.localStorage.getItem('adminNavTabsRemembered');

		if (storage)
			storage = JSON.parse(storage);
		else
			storage = {};

		return storage;
	}
}

class NavTab {
	constructor(wrap, navTabs) {
		const self   = this;
		this.onClick = [];
		this.navTabs = navTabs;
		this.wrap    = wrap;
		this.links   = this.wrap.querySelectorAll('.nav-tabs__link');
		this.tabs    = [];
		this.scope   = this.wrap.closest('.tab-content__panel') || document;

		const getTabs = (e) => {
			this.links.forEach(link => {
				let tabId        = self.getLinkId(link);
				this.tabs[tabId] = this.scope.querySelector('#' + tabId);
			});
		}



		this.links.forEach(link => {
			link.addEventListener('click', e => {
				e.preventDefault();
				self.clearActive();

				getTabs();

				let href = self.getLinkId(link);

				link.classList.add('active');

				let tabContent = self.tabs[href];
				if (tabContent)
					tabContent.classList.add('active');

				for (let i = 0; i < this.onClick.length; i++)
					this.onClick[i](link, href);
			});
		});
	}

	getLinkId(link) {
		return link.getAttribute('href').substr(1);
	}

	clearActive() {
		this.wrap.querySelectorAll('.nav-tabs__link.active').forEach(el => {
			el.classList.remove('active');
			this.scope.querySelector('#' + el.getAttribute('href').substr(1)).classList.remove('active');
		});
	}
}
