CKEDITOR.plugins.add('rsfaq', {
	requires: 'widget',

	init: function (editor) {
		var pluginName = 'RsFaq';

		// editor.addContentsCss('/assets/admin2/css/ckeditor-productForm.css');
		editor.widgets.add('RsFaq', {
			requiredContent: 'div(rsFaq)',
			template       : '<div class="rsFaq" itemscope itemprop="mainEntity" itemtype="https://schema.org/Question">' +
				'<p itemprop="name" class="rsFaq__question">Otázka</p>' +
				'<div itemscope itemprop="acceptedAnswer" itemtype="https://schema.org/Answer">' +
				'<p itemprop="text" class="rsFaq__answer">Odpověď</p>' +
				'</div>' +
				'</div>',
			button         : 'RS FAQ',
			editables      : {
				question: {
					selector: '.rsFaq__question',
					allowedContent: 'h1;h2;h3;h4;h5;h6;strong;b;em;a;span;p',
				},
				answer: {
					selector: '.rsFaq__answer',
					allowedContent: 'h1;h2;h3;h4;h5;h6;strong;b;em;a;span;p',
				},
			},
			upcast         : function (element) {
				return element.name == 'div' && element.hasClass('rsFaq');
			}
		});
	}
});
