<?php declare(strict_types = 1);

namespace Core\AdminModule\Components\Cookies;

use Core\AdminModule\Model\Sites;
use Core\Model\CookieAdditionalServices;
use Core\Model\Entities\CookieAdditionalService;
use Core\Model\UI\BaseControl;
use Core\Model\UI\DataGrid\BaseDataGrid;
use Core\Model\UI\Form\BaseForm;

class ServicesGrid extends BaseControl
{
	public function __construct(
		protected CookieAdditionalServices $cookieAdditionalServices,
		protected IServiceFormFactory      $serviceFormFactory,
		protected Sites                    $adminSites,
	)
	{
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ======================== COMPONENTS
	 */

	protected function createComponentGrid(): BaseDataGrid
	{
		$grid = $this->createGrid();

		$grid->setDataSource($this->cookieAdditionalServices->getAllWithDefaults());

		$grid->addColumnText('name', 'core.servicesGrid.name');

		if (count($this->adminSites->getOptionsForSelect()) > 1) {
			$grid->addColumnText('sites', 'core.servicesGrid.site');
		}
		$grid->addAction('edit', '', 'edit!')
			->setRenderCondition(fn($arr) => !$arr['isDefault'])
			->setIcon('edit')
			->setBsType('primary')
			->addClass('ajax');
		$grid->addAction('delete', '', 'delete!')
			->setRenderCondition(fn($arr) => !$arr['isDefault'])
			->setIcon('times')
			->setBsType('danger')
			->addClass('ajax')
			->setConfirm('default.reallyDelete');

		return $grid;
	}

	public function createComponentForm(): ServiceForm
	{
		$control                                  = $this->serviceFormFactory->create();
		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this['grid']->reload();
			$this->presenter->redrawControl('flashes');
		};
		$control['form']->onSuccessSaveAndClose[] = function(BaseForm $form) {
			$this['grid']->reload();
			$this->presenter->payload->hideModal = true;
			$this->presenter->redrawControl('flashes');
		};
		$control['form']->getComponent('saveControl')->closeModalOnCancel();

		return $control;
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	public function handleAdd(): void
	{
		$this->template->modalTitle = $this->t('core.title.addService');
		$this->template->modal      = 'serviceForm';
		$this->redrawControl('modal');
	}

	public function handleEdit(string $id): void
	{
		$form = $this['form'];

		/** @var CookieAdditionalService $service */
		$service = $this->cookieAdditionalServices->getEr()->findOneBy(['ident' => $id]);
		$form->setService($service);
		$this->template->modalTitle = $service->name;
		$this->template->modal      = 'serviceForm';
		$this->redrawControl('modal');
	}

	public function handleDelete(string $id): void
	{
		if ($this->cookieAdditionalServices->removeByIdent($id)) {
			$this->presenter->flashMessageSuccess('default.removed');
		} else {
			$this->presenter->flashMessageDanger('default.removeFailed');
		}

		$this['grid']->reload();
		$this->presenter->redrawControl('flashes');
	}

}
