<?php declare(strict_types = 1);

namespace Core\AdminModule\Components\Redirects;

use Core\AdminModule\Model\Redirects;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Utils\ArrayHash;

class ValidateForm extends BaseControl
{
	public function __construct(protected Redirects $redirects)
	{
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setShowLangSwitcher(false);
		$form->setAjax();

		$form->addText('offset', 'core.redirectsValidate.offset')
			->setHtmlType('number')
			->setDefaultValue(0)
			->setRequired();
		$form->addText('limit', 'core.redirectsValidate.limit')
			->setHtmlType('number')
			->setDefaultValue(20)
			->setRequired();

		$form->addSubmit('validate', 'core.redirectsValidate.validate');

		$form->onSuccess[] = $this->formSuccess(...);

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): void
	{
		set_time_limit(intval($values->limit) * 20);
		$this->redirects->validateRedirects((int) $values->offset, (int) $values->limit);

		$this->presenter->flashMessageSuccess('core.redirectsValidate.validated');
		$this->presenter->redrawControl('flashes');
	}
}
