<?php declare(strict_types = 1);

namespace Core\AdminModule\Model;

use Core\Model\WebColors;
use Exception;
use Nette\Utils\FileSystem;
use ScssPhp\ScssPhp\Compiler;

class ColorsCompiler
{
	public function __construct(protected WebColors $webColors)
	{
	}

	public function compile(string $siteIdent = ''): bool
	{
		$this->webColors->clearCache();
		$vars = $this->webColors->getColors($siteIdent);

		$scss = new Compiler();

		$scss->setVariables($vars);
		$scss->setImportPaths(SRC_DIR . '/core/assets/front/src/globalScss/');

		$filePrefix = $siteIdent === '' ? $siteIdent : $siteIdent . '_';

		$oldFile = ASSETS_DIR . '/front/dist/' . $filePrefix . 'webColorsOld.css';
		$newFile = ASSETS_DIR . '/front/dist/' . $filePrefix . 'webColors.css';
		$tmpFile = TMP_DIR . '/webColors.tmp';

		try {
			file_put_contents($tmpFile, $scss->compile('@import "settings.scss";'));
			if (file_exists($newFile))
				FileSystem::rename($newFile, $oldFile);
			FileSystem::rename($tmpFile, $newFile);
			FileSystem::delete($tmpFile);
			FileSystem::delete(TMP_DIR . '/cache/latte');
		} catch (Exception $e) {
			bdump($e->getMessage());

			return false;
		}

		return true;
	}
}
