<?php declare(strict_types = 1);

namespace Core\AdminModule\Model;

use Core\Model\Entities\Site;
use Core\Model\Helpers\BaseEntityService;
use Doctrine\ORM\NonUniqueResultException;

/**
 * @method Site getReference($id)
 */
class Sites extends BaseEntityService
{
	protected $entityClass = Site::class;

	protected ?array $cAll    = null;
	protected ?array $cIdents = null;

	/**
	 * @param string $name
	 *
	 * @throws NonUniqueResultException
	 */
	public function get($name): ?Site
	{
		return $this->getEr()->createQueryBuilder('s')
			->addSelect('st')
			->innerJoin('s.texts', 'st')
			->where('s.ident = :ident')
			->setParameter('ident', $name)
			->getQuery()->getOneOrNullResult();
	}

	/**
	 * @return Site[]
	 */
	public function getAll(bool $onlyVisible = true): array
	{
		if ($this->cAll === null) {
			$qb = $this->getEr()->createQueryBuilder('s')
				->innerJoin('s.texts', 'st');

			if ($onlyVisible) {
				$qb->where('s.isVisible = 1');
			}

			$this->cAll = $qb->getQuery()->getResult();
		}

		return $this->cAll;
	}

	public function getOptionsForSelect(bool $onlyVisible = true): array
	{
		$arr = [];
		$qb  = $this->getEr()->createQueryBuilder('s')->select('s.ident');

		if ($onlyVisible)
			$qb->where('s.isVisible = 1');

		foreach ($qb->getQuery()->getScalarResult() as $row) {
			$arr[$row['ident']] = $row['ident'];
		}

		return $arr;
	}

	public function getIdents(bool $onlyVisible = true): array
	{
		if ($this->cIdents === null) {
			$this->cIdents = [];

			$qb = $this->getEr()->createQueryBuilder('s')
				->select('s.ident');

			if ($onlyVisible) {
				$qb->andWhere('s.isVisible = 1');
			}

			foreach ($qb->getQuery()->getArrayResult() as $row) {
				$this->cIdents[$row['ident']] = $row['ident'];
			}
		}

		return $this->cIdents;
	}
}
