<?php declare(strict_types = 1);

namespace Core\AdminModule\Presenters;

use Core\AdminModule\Components\Country\CountryForm;
use Core\AdminModule\Components\Country\CountryGrid;
use Core\AdminModule\Components\Country\ICountryFormFactory;
use Core\AdminModule\Components\Country\ICountryGridFactory;
use Core\Model\Entities\Country;
use Core\Model\UI\Form\BaseForm;

class CountryPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'settings')) {
			$this->error();
		}

		$this->setHeader('admin.title.country', 'fas fa-flag');
	}

	/*******************************************************************************************************************
	 * ===============================  Render
	 */

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(): void
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'admin.menu.countryAdd',
				'link'  => 'Country:addCountry',
				'ico'   => 'plus',
			],
		]]);
	}

	public function actionAddCountry(): void
	{
		$this->setTitle($this->translator->translate('admin.menu.countryAdd'));
		$this->setHeader('admin.menu.countryAdd', 'fa fa-flag');
	}

	public function actionEditCountry(string $id): void
	{
		$country = $this->em->getRepository(Country::class)->find($id);

		if (!$country) {
			$this->error();
		}

		$this->setTitle($this->translator->translate('admin.title.countryEdit'), $country->name);
		$this->setHeader('admin.title.countryEdit', 'fa fa-flag');
	}

	/*******************************************************************************************************************
	 * ===============================  Components
	 */

	protected function createComponentCountryGrid(ICountryGridFactory $factory): CountryGrid
	{
		return $factory->create();
	}

	protected function createComponentCountryForm(ICountryFormFactory $factory): CountryForm
	{
		$control = $factory->create();

		if ($this->getParameter('id')) {
			$control->setCountry($this->getParameter('id'));
		}

		$control['form']->onSuccessSave[]         = function(BaseForm $form): never {
			$this->redirect('editCountry', $form->getCustomData('countryId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function(BaseForm $form): never {
			$this->redirect('default');
		};
		$control['form']->onCancel[]              = function(BaseForm $form): never {
			$this->redirect('default');
		};

		return $control;
	}
}
