<?php declare(strict_types = 1);

namespace Core\ApiModule\Model\Middlewares;

use Contributte\Middlewares\IMiddleware;
use Core\Model\Parameters;
use Nette\Utils\Json;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use function str_starts_with;

class BasicBaseAuthMiddleware implements IMiddleware
{
	public function __invoke(
		ServerRequestInterface $request,
		ResponseInterface      $response,
		callable               $next,
	): ResponseInterface
	{
		foreach (Parameters::load('api.basicAuthEndPoints') as $key => $url) {
			if (str_starts_with($request->getUri()->getPath(), (string) $url)) {
				$authorization = $this->parseAuthorizationHeader($request->getHeaderLine('Authorization'));

				if ($authorization
					&& $authorization['key'] === Parameters::load("api.basicAuth.{$key}.username")
					&& $authorization['password'] === Parameters::load("api.basicAuth.{$key}.password")
				) {
					return $next(
						$request
							->withAttribute('authenticated', true),
						$response,
					);
				}

				$response->getBody()->write(
					Json::encode([
						'status'  => 'error',
						'message' => 'Client authentication failed',
						'code'    => 401,
					]),
				);

				return $response
					->withHeader('Content-Type', 'application/json')
					->withStatus(401);
			}
		}

		return $next($request, $response);
	}

	protected function parseAuthorizationHeader(string $header): ?array
	{
		if (!str_starts_with($header, 'Basic')) {
			return null;
		}

		$header = explode(':', (string) base64_decode(substr($header, 6), true), 2);

		return [
			'key'      => $header[0],
			'password' => $header[1] ?? null,
		];
	}

}
