<?php declare(strict_types = 1);

namespace Core\Components\Flashes;

use Core\Model\Http\Session;
use Core\Model\UI\BaseControl;
use Nette;
use Nette\HtmlStringable;
use stdClass;

class Flashes extends BaseControl
{
	final public const FLASH_PRIMARY   = 'primary';
	final public const FLASH_SECONDARY = 'secondary';
	final public const FLASH_SUCCESS   = 'success';
	final public const FLASH_DANGER    = 'danger';
	final public const FLASH_WARNING   = 'warning';
	final public const FLASH_INFO      = 'info';

	protected static array $newFlashes = [];

	public function __construct(protected Session $session)
	{
	}

	public function render(array $parameters = null): void
	{
		if ($parameters) {
			$this->template->parameters = Nette\Utils\ArrayHash::from($parameters);
		}

		$presenter = $this->presenter;

		foreach (self::$newFlashes as $k => $v) {
			$presenter->flashMessage($v['message'], $v['type']);
			unset(self::$newFlashes[$k]);
		}

		$flashes = $presenter->getTemplate()->flashes;

		if ($this->session->isStarted() && $presenter->hasFlashSession()) {
			$flashSession = $presenter->getFlashSession();
			$flashSession->setExpiration('1 minute');
			$flashes = $flashSession->flash;
		}

		$this->template->flashes = $flashes ?? [];
		$this->template->render($this->getTemplateFile());
	}

	public static function addFlashMessage(string|stdClass|HtmlStringable $message, string $type): void
	{
		self::$newFlashes[] = [
			'message' => $message,
			'type'    => $type,
		];
	}

	public static function hasNewFlashes(): bool { return (bool) count(self::$newFlashes); }
}
