<?php declare(strict_types = 1);

namespace Core\ErrorModule\Presenters;

use Core\Components\Navigation\DaoNavigationItem;
use Core\Components\Navigation\INavigationFactory;
use Core\Components\Navigation\Navigation;
use Navigations\Model\Navigations;
use Nette\ComponentModel\IComponent;
use Nette\DI\Attributes\Inject;

abstract class BasePresenter extends CustomBasePresenter
{
	#[Inject]
	public Navigations $navigationsService;

	protected function startup(): void
	{
		parent::startup();
		$this['meta']->setMeta('robots', 'noindex,nofollow');
		$this['title']->setTitle($this->translator->translate('default.errorPage.title'));

		$tmp = explode('/', $this->getHttpRequest()->getUrl()->getPath());

		if ($tmp[1] && array_key_exists($tmp[1], $this->langsService->getLangs(false))) {
			$this->langsService->setDefault($tmp[1]);
			$this->translator->setLocale($tmp[1]);
			$this->locale = $tmp[1];
		}
	}

	protected function createComponentNavigation(INavigationFactory $factory): Navigation
	{
		$control = $factory->create();
		$control->setData($this->navigationsService->getPublishedDaoNavigationStructure());

		return $control;
	}

	public function getActiveNavigation(): ?DaoNavigationItem
	{
		return $this->navigationsService->getHomepage();
	}

	/*******************************************************************************************************************
	 * =============================== Handle
	 */

	public function handleLogout(): void
	{
		$homepage = $this->navigationsService->getHomepage($this->locale);

		if ($homepage) {
			$link = is_array($homepage->link) ? $homepage->link[0] : $homepage->link;
		} else {
			$link = '/';
		}

		$this->getUser()->logout(true);
		$this->redirectUrl($link);
	}

	protected function createComponent(string $name): ?IComponent
	{
		$component = parent::createComponent($name);

		if (!$component) {
			$sl = $this->getComponentFactoriesLocator();

			foreach ($sl->findByTag('dynamicComponent') as $k => $v) {
				if ($v !== $name) {
					continue;
				}

				if (!$sl->hasService($k)) {
					continue;
				}

				$component = $sl->getService($k)->create();
			}
		}

		return $component;
	}
}
