<?php declare(strict_types = 1);

namespace Core\ErrorModule\Presenters;

use Core\FrontModule\Model\Redirects;
use Nette;

/**
 * Class Error4xxPresenter
 * @package Core\ErrorModule\Presenters
 */
class Error4xxPresenter extends BasePresenter
{
	/** @var Redirects @inject */
	public $redirectsService;

	public function startup(): void
	{
		parent::startup();

		$this->redirectsService->findRedirect($this->getHttpRequest()->getUrl()->getPath());

		if (!$this->getRequest()->isMethod(Nette\Application\Request::FORWARD)) {
			$this->error();
		}
	}
}
