<?php declare(strict_types = 1);

namespace Core\FrontModule\Presenters;

use Contributte\Application\Response\XmlResponse;
use Core\FrontModule\Model\SiteMap;
use Core\Model\Sites;
use Core\Model\SystemConfig;
use Thepixeldeveloper\Sitemap\Drivers\XmlWriterDriver;

class SitemapPresenter extends BasePresenter
{
	public function __construct(protected Sites $sites, protected SiteMap $siteMap)
	{
	}

	public function actionDefault(string $site, string $group, string $lang): void
	{
		if (!SystemConfig::load('autoGenerateSitemap')) {
			$this->error();
		}

		$domain = $this->sites->getSites()[$site]->getDomains()[$lang] ?? null;
		if (!$domain) {
			$this->error();
		}

		$this->sites->getCurrentSite()->currentLang = $domain->getLang();
		$lang                                       = $domain->getLang();

		$sitemap = $this->siteMap->getSiteMap($lang, $group);

		if (!$sitemap) {
			$this->error();
		}

		$driver = new XmlWriterDriver();
		$sitemap->accept($driver);

		$output = $driver->output();

		if (isset($sitemap->all()[0]) && $sitemap->all()[0] instanceof \Thepixeldeveloper\Sitemap\Sitemap) {
			foreach ($sitemap->all() as $k => $v) {
				$tmp = $this->siteMap->getSiteMap($lang, $group, $k + 1);

				if (!$tmp) {
					continue;
				}

				$driver = new XmlWriterDriver();
				$tmp->accept($driver);

				$output .= $driver->output();
				$tmp    = null;
			}
		}
		$sitemap = null;

		$this->sendResponse(new XmlResponse($output));
	}
}
