<?php declare(strict_types = 1);

namespace Core\Model;

use App\Bootstrap;
use Nette\Bootstrap\Configurator;
use Nette\DI\InvalidConfigurationException;
use Tester\Environment;

class BootstrapTest
{
	public static function bootForTests(): Configurator
	{
		$devTestConfFile = __DIR__ . '/../../../../../app/config/config.local.tester.neon';

		if (!file_exists($devTestConfFile)) {
			throw new InvalidConfigurationException('config.local.tester.neon not found (in: config folder)');
		}

		$configurator = Bootstrap::boot();
		Environment::setup();
		error_reporting(~E_USER_DEPRECATED & ~E_WARNING & ~E_NOTICE & ~E_USER_WARNING & ~E_USER_NOTICE);

		return $configurator;
	}
}
